/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.io.StringReader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import oracle.install.commons.swing.StatusMessageDialog;
import oracle.install.commons.util.StatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.ErrorMessage;
import oracle.install.commons.util.exception.ErrorMessageHelper;

public class StatusMessagePane
extends JPanel {
    private static Logger logger = Logger.getLogger(StatusMessagePane.class.getName());
    private static Icon ICON_ERROR;
    private static final String FMT_MESSAGE = "<tr class=\"{0}\"><td align=\"center\" valign=\"top\" width=\"5\"><img alt=\"{1}\" title=\"{1}\" width=\"{2}\" height=\"{3}\" src=\"{4}\"></td><td width=\"100%\">{5}</td</tr>";
    private static final String FMT_MESSAGE_UNIMODE = "<html><body><table id=\"messages\" width=\"100%\"><tr class=\"odd\"><td width=\"100%\">{0}</td</tr></table></body></html>";
    public static final Dimension DEFAULT_SIZE;
    public static final int LIMIT_UNLIMITED = -1;
    private boolean oddRow;
    private JTextPane txpStatusMessages;
    private HTMLDocument htmlDocument;
    private Element messageTableElement;
    private int maxLimit;

    public StatusMessagePane() {
        this.buildUI();
        this.setPreferredSize(DEFAULT_SIZE);
        this.maxLimit = -1;
    }

    public int getMaxLimit() {
        return this.maxLimit;
    }

    public void setMaxLimit(int maxLimit) {
        this.maxLimit = maxLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildUI() {
        this.txpStatusMessages = new JTextPane();
        this.txpStatusMessages.setEditable(false);
        this.txpStatusMessages.setContentType("text/html");
        this.txpStatusMessages.addHyperlinkListener(ErrorMessageHelper.getSharedErrorCodeHyperLinkListener());
        this.htmlDocument = (HTMLDocument)this.txpStatusMessages.getDocument();
        StyleSheet stylesheet = this.htmlDocument.getStyleSheet();
        StringBuffer cssBuffer = new StringBuffer();
        Font font = this.txpStatusMessages.getFont();
        cssBuffer.append("body {font-size: " + font.getSize() + ";font-family: " + font.getFamily() + "}");
        cssBuffer.append("\n.odd {background-color: #FFFFFF}");
        cssBuffer.append("\n.even {background-color: #EEEEEE}");
        StringReader reader = new StringReader(cssBuffer.toString());
        try {
            stylesheet.loadRules(reader, null);
        }
        catch (Exception e) {
            logger.warning("Failed to set the CSS. Error: " + e.getMessage());
        }
        finally {
            reader.close();
        }
        URL baseUrl = this.getClass().getResource("/oracle/install/commons/swing/resource/");
        if (baseUrl != null) {
            this.htmlDocument.setBase(baseUrl);
        } else {
            logger.warning("Failed to set the document base URL.");
        }
        this.setLayout(new BorderLayout());
        this.add(new JScrollPane(this.txpStatusMessages));
        this.reset();
    }

    public void reset() {
        this.oddRow = false;
        this.txpStatusMessages.setText("<html><body><table id=\"messages\" width=\"100%\"></table></body></html>");
        this.messageTableElement = this.htmlDocument.getElement("messages");
    }

    public void appendStatusMessage(StatusMessage statusMessage) {
        try {
            String message = statusMessage.getMessage();
            if (statusMessage instanceof ErrorMessage) {
                message = ErrorMessageHelper.formatMessage((ErrorMessage)statusMessage, message);
            }
            if (this.maxLimit != 1) {
                String htmlText = MessageFormat.format(FMT_MESSAGE, this.oddRow ? "odd" : "even", "", ICON_ERROR.getIconWidth(), ICON_ERROR.getIconHeight(), statusMessage.getLevel() == Level.SEVERE ? "error.png" : "warning.png", message);
                this.htmlDocument.insertBeforeEnd(this.messageTableElement, htmlText);
                this.oddRow = !this.oddRow;
            } else {
                String htmlText = MessageFormat.format(FMT_MESSAGE_UNIMODE, message);
                this.txpStatusMessages.setText(htmlText);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static int showDialog(Component owner, String title, StatusMessages<? extends StatusMessage> statusMessages) {
        Window window = null;
        if (owner != null) {
            window = SwingUtilities.windowForComponent(owner);
        }
        StatusMessageDialog dialog = null;
        dialog = window instanceof Dialog ? new StatusMessageDialog((Dialog)window) : (window instanceof Frame ? new StatusMessageDialog((Frame)window) : new StatusMessageDialog((Frame)null));
        int statusCode = -1;
        dialog.setTitle(title);
        statusCode = dialog.show(statusMessages);
        dialog.dispose();
        return statusCode;
    }

    static {
        URL url = StatusMessagePane.class.getResource("/oracle/install/commons/swing/resource/error.png");
        if (url != null) {
            ICON_ERROR = new ImageIcon(url);
        }
        DEFAULT_SIZE = new Dimension(400, 150);
    }
}

